/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt Quick Controls 2 module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
******************************************************************************/

import QtQuick
import QtQuick.Templates as T
import QtQuick.Controls.impl
import QtQuick.Controls.Fusion
import QtQuick.Controls.Fusion.impl

T.ToolBar {
    id: control

    implicitWidth: Math.max(implicitBackgroundWidth + leftInset + rightInset,
                            contentWidth + leftPadding + rightPadding)
    implicitHeight: Math.max(implicitBackgroundHeight + topInset + bottomInset,
                             contentHeight + topPadding + bottomPadding)

    horizontalPadding: 6
    topPadding: control.position === T.ToolBar.Footer ? 1 : 0
    bottomPadding: control.position === T.ToolBar.Header ? 1 : 0

    background: Rectangle {
        implicitHeight: 26

        gradient: Gradient {
            GradientStop {
                position: 0
                color: Qt.lighter(control.palette.window, 1.04)
            }
            GradientStop {
                position: 1
                color: control.palette.window
            }
        }

        Rectangle {
            width: parent.width
            height: 1
            color: control.position === T.ToolBar.Header ? Fusion.lightShade : Fusion.darkShade
        }

        Rectangle {
            y: parent.height - height
            width: parent.width
            height: 1
            color: control.position === T.ToolBar.Header ? Fusion.darkShade : Fusion.lightShade
        }
    }
}
